unit VCLINK32; {Feb14/97 9:30am}{Aug 18/99 BRM}

interface

uses WinTypes, VCType32;

function VCLoadVCLINK32 : boolean;
procedure VCFreeVCLINK32;
procedure VCCreateSymbolFromSelectionBP(var iError: smallint; szName: PChar; var dpP: Point2D); stdcall;
procedure VCDigPointBP(var lpt: Point2D; bButtonNum: smallint; bButtonState: smallint);stdcall;
procedure VCGetDatumBasePtBP(var iError: smallint; var dpRet: Point2D); stdcall;
procedure VCMouseMoveWorldPointBP(var dpW: Point2D); stdcall;
procedure VCPaintBP(hWnd: longint; var rc: rect); stdcall;
procedure VCScreenToWorld2DBP(var iError: smallint; var ipScreen: Point2D; var dpWorld: Point2D); stdcall;
procedure VCSetDatumBasePtBP(var iError: smallint; var p: Point2D); stdcall;
procedure VCSetScaleXYBP(var iError: smallint; var dpP: Point2D); stdcall;
procedure VCSetSymScaleBP (var iError: smallint; var dpScale: Point2D); stdcall;

implementation

var
    hInst : THandle;

function VCLoadVCLINK32 : boolean;
begin
  hInst := LoadLibrary('VCLINK32.DLL');
  result := hInst >= 32;
end;

procedure VCFreeVCLINK32;
begin
  FreeLibrary(hInst);
end;

type TVCCreateSymbolFromSelectionBP = procedure (var iError: smallint; szName: PChar; var dpP: Point2D); stdcall;

procedure VCCreateSymbolFromSelectionBP (var iError: smallint; szName: PChar; var dpP: Point2D); stdcall;
var aproc : TVCCreateSymbolFromSelectionBP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCCreateSymbolFromSelectionBP');
  if @aproc <> nil then
     aproc(iError, szName, dpP);
end;

type TVCDigPointBP = procedure(var lpt: Point2D; bButtonNum: smallint; bButtonState: smallint);stdcall;

procedure VCDigPointBP(var lpt: Point2D; bButtonNum: smallint; bButtonState: smallint);stdcall;
var aproc : TVCDigPointBP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDigPointBP');
  if @aproc <> nil then
      aproc(lpt, bButtonNum, bButtonState);
end;

type TVCGetDatumBasePtBP = procedure (var iError: smallint; var dpRet: Point2D); stdcall;

procedure VCGetDatumBasePtBP(var iError: smallint; var dpRet: Point2D); stdcall;
var aproc : TVCGetDatumBasePtBP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCGetDatumBasePtBP');
  if @aproc <> nil then
     aproc(iError,dpRet);
end;

type TVCMouseMoveWorldPointBP = procedure (var dpW: Point2D); stdcall;

procedure VCMouseMoveWorldPointBP (var dpW: Point2D);
var aproc : TVCMouseMoveWorldPointBP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMouseMoveWorldPointBP');
  if @aproc <> nil then
      aproc(dpW);
end;

type TVCPaintBP = procedure(hWnd: longint; var rc: rect); stdcall;

procedure VCPaintBP(hWnd: longint; var rc: rect); stdcall;
var aproc : TVCPaintBP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPaintBP');
  if @aproc <> nil then
      aproc(hWnd,rc);
end;

type TVCScreenToWorld2DBP = procedure (var iError: smallint; var ipScreen: Point2D; var dpWorld: Point2D); stdcall;

procedure VCScreenToWorld2DBP(var iError: smallint; var ipScreen: Point2D; var dpWorld: Point2D); stdcall;
var aproc : TVCScreenToWorld2DBP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCScreenToWorld2DBP');
  if @aproc <> nil then
      aproc(iError, ipScreen, dpWorld);
end;

type TVCSetDatumBasePtBP = procedure (var iError: smallint; var p: Point2D); stdcall;

procedure VCSetDatumBasePtBP(var iError: smallint; var p: Point2D); stdcall;
var aproc : TVCSetDatumBasePtBP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetDatumBasePtBP');
  if @aproc <> nil then
      aproc(iError, p);
end;
type TVCSetScaleXYBP = procedure (var iError: smallint; var dpP: Point2D); stdcall;

procedure VCSetScaleXYBP (var iError: smallint; var dpP: Point2D);
var aproc : TVCSetScaleXYBP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetScaleXYBP');
  if @aproc <> nil then
      aproc(iError, dpP);
end;

type TVCSetSymScaleBP = procedure (var iError: smallint; var dpScale: Point2D); stdcall;

procedure VCSetSymScaleBP (var iError: smallint; var dpScale: Point2D);
var aproc : TVCSetSymScaleBP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetSymScaleBP');
  if @aproc <> nil then
      aproc(iError, dpScale);
end;


end.
